/* - PHAttachListener -
 * We'll populate the fields in the GUI and enable the modify sensitivity textbox
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.PHSensorPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachListener;
import com.phidgets.event.AttachEvent;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PHAttachListener implements AttachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField phTxt;
    private JLabel PHRngLbl;
    private JTextField potTxt;
    private JLabel potentialRngLbl;
    private JTextField sensitivityTxt;
    private JTextField tempTxt;
    
    /** Creates a new instance of PHAttachListener */
    public PHAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt, JTextField phTxt, 
            JLabel PHRngLbl, JTextField potTxt, JLabel potentialRngLbl,
            JTextField sensitivityTxt, JTextField tempTxt)
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.phTxt = phTxt;
        this.PHRngLbl = PHRngLbl;
        this.potTxt = potTxt;
        this.potentialRngLbl = potentialRngLbl;
        this.sensitivityTxt = sensitivityTxt;
        this.tempTxt = tempTxt;
    }

    public void attached(AttachEvent ae)
    {
        try
        {
            PHSensorPhidget attached = (PHSensorPhidget)ae.getSource();
            attachedTxt.setText(Boolean.toString(attached.isAttached()));
            nameTxt.setText(attached.getDeviceName());
            serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            
            PHRngLbl.setText("(" + attached.getPotentialMin() + " - " + attached.getPotentialMax() + ")");
            potentialRngLbl.setText("(" + attached.getPotentialMin() + "mV - " + attached.getPotentialMax() + "mV)");
            
            sensitivityTxt.setEnabled(true);
            tempTxt.setEnabled(true);
        }
        catch (PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
